#include "General.h"
#include "CharacterRefundKebab.h"
#include "gmgame.h"

int CurrentDeaths[128];
int CurrentValue[128];

#define GREEN "104,234,40"

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

// Uses CMSGP if scripts verion supports it, otherwise uses PPAGE
void Page(int ID, const char* rgb_colour, const char *Format, ...)
{
	if ( (ID < 1) || (ID > 128) ) return;
	if (!Get_GameObj(ID)) return;

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if (Version < 2.9)
	{
		Console("PPAGE %d %s", ID, buffer);
	}
	else
	{
		Console("CMSGP %d %s %s", ID, rgb_colour, buffer);
	}
}

CharacterRefundKebab::CharacterRefundKebab()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK, this);
	RegisterEvent(EVENT_CHARACTER_PURCHASE_HOOK, this);
}

CharacterRefundKebab::~CharacterRefundKebab()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK, this);
	UnregisterEvent(EVENT_CHARACTER_PURCHASE_HOOK, this);
}

void CharacterRefundKebab::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	Multiplier = SSGMIni->Get_Float("CharacterRefund", "FractionOfRefund", 1.0f);
}

void CharacterRefundKebab::OnLoadLevel()
{
	for(int i = 0; i < 128; i++)
	{
		CurrentDeaths[i] = 0;
		CurrentValue[i] = 0;
	}
}

void CharacterRefundKebab::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	CurrentDeaths[PlayerID] = Find_Player(PlayerID)->Get_Deaths();
	CurrentValue[PlayerID] = 0;
}

int CharacterRefundKebab::OnCharacterPurchase(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset,const char *data)
{
	int PlayerID = Get_Player_ID(purchaser);

	if ( (CurrentDeaths[PlayerID] == Find_Player(PlayerID)->Get_Deaths()) && ( CurrentValue[PlayerID] > 0 ) )
	{
		float Refund = (float)CurrentValue[PlayerID] * Multiplier * (Is_Base_Powered(base->Get_Player_Type()) ? 1.0f : 2.0f);

		Commands->Give_Money(purchaser, Refund, 0);
		Page(PlayerID, GREEN, "You have been refunded %.0f credits for changing characters.", Refund);
	}

	CurrentDeaths[PlayerID] = Find_Player(PlayerID)->Get_Deaths();
	CurrentValue[PlayerID] = cost;

	return -1;
}

CharacterRefundKebab characterRefundKebab;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &characterRefundKebab;
}
